<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Peta Mempawah - Portal Informasi Geografis</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=outfit:400,500,600,700,800&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                    },
                    animation: {
                        'gradient': 'gradient 8s linear infinite',
                        'float': 'float 6s ease-in-out infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                    },
                    keyframes: {
                        gradient: {
                            '0%, 100%': { 'background-size': '200% 200%', 'background-position': 'left center' },
                            '50%': { 'background-size': '200% 200%', 'background-position': 'right center' },
                        },
                        float: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-20px)' },
                        }
                    }
                }
            }
        }
    </script>

    <style>
        .glass {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.03);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .glass-card:hover {
            background: rgba(255, 255, 255, 0.08);
            transform: translateY(-8px) scale(1.02);
            border-color: rgba(255, 255, 255, 0.2);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }

        .bg-mesh {
            background-color: #020617;
            background-image:
                radial-gradient(at 0% 0%, hsla(243, 98%, 51%, 0.15) 0px, transparent 50%),
                radial-gradient(at 100% 0%, hsla(199, 89%, 48%, 0.15) 0px, transparent 50%),
                radial-gradient(at 100% 100%, hsla(243, 98%, 51%, 0.15) 0px, transparent 50%),
                radial-gradient(at 0% 100%, hsla(199, 89%, 48%, 0.15) 0px, transparent 50%);
        }

        .gradient-text {
            background: linear-gradient(to right, #60a5fa, #a78bfa, #f472b6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-size: 200% auto;
            animation: gradient 5s linear infinite;
        }

        .map-line {
            stroke-dasharray: 1000;
            stroke-dashoffset: 1000;
            animation: dash 10s linear infinite;
        }

        @keyframes dash {
            to {
                stroke-dashoffset: 0;
            }
        }
    </style>
</head>

<body class="bg-mesh text-slate-200 min-h-screen selection:bg-blue-500/30">

    <!-- Navbar -->
    <nav class="fixed top-0 w-full z-50 px-6 py-4">
        <div class="max-w-7xl mx-auto flex justify-between items-center glass px-6 py-3 rounded-2xl">
            <div class="flex items-center gap-2">
                <div
                    class="w-8 h-8 rounded-lg bg-blue-600 flex items-center justify-center shadow-lg shadow-blue-500/20">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7" />
                    </svg>
                </div>
                <span class="text-xl font-bold tracking-tight">Peta<span class="text-blue-500">Mempawah</span></span>
            </div>
            <div class="hidden md:flex items-center gap-8 text-sm font-medium">
                <a href="#peta" class="hover:text-blue-400 transition-colors">Peta Eksternal</a>
                <a href="#perencanaan" class="hover:text-blue-400 transition-colors">Perencanaan</a>
                <a href="/map"
                    class="px-5 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-xl transition-all shadow-lg shadow-blue-500/25 active:scale-95">GIS
                    Map View</a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="relative pt-32 pb-20 px-6 overflow-hidden">
        <div class="absolute inset-0 z-0 opacity-20 pointer-events-none">
            <svg class="w-full h-full" viewBox="0 0 1000 1000" xmlns="http://www.w3.org/2000/svg">
                <path class="map-line" d="M0,500 Q250,400 500,500 T1000,500" stroke="rgba(59, 130, 246, 0.5)"
                    fill="none" stroke-width="1" />
                <path class="map-line" d="M0,300 Q250,200 500,300 T1000,300" stroke="rgba(147, 51, 234, 0.3)"
                    fill="none" stroke-width="1" />
                <path class="map-line" d="M0,700 Q250,600 500,700 T1000,700" stroke="rgba(59, 130, 246, 0.2)"
                    fill="none" stroke-width="1" />
            </svg>
        </div>

        <div class="max-w-7xl mx-auto relative z-10 text-center">
            <div
                class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-blue-500/10 border border-blue-500/20 text-blue-400 text-xs font-bold mb-6 animate-pulse-slow">
                <span class="w-2 h-2 rounded-full bg-blue-500"></span> NEW INTERACTIVE GIS DASHBOARD
            </div>
            <h1 class="text-5xl md:text-7xl font-extrabold tracking-tight mb-6 leading-tight">
                Visualisasi Data Geografis <br class="hidden md:block">
                Dengan <span class="gradient-text">PetaMempawah Portal</span>
            </h1>
            <p class="text-lg md:text-xl text-slate-400 max-w-2xl mx-auto mb-10 leading-relaxed">
                Platform terintegrasi untuk mengakses berbagai layanan peta digital, perencanaan wilayah, dan data GIS
                interaktif dalam satu genggaman.
            </p>
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <a href="/map"
                    class="w-full sm:w-auto px-8 py-4 bg-blue-600 hover:bg-blue-700 text-white rounded-2xl font-bold transition-all shadow-xl shadow-blue-500/30 flex items-center justify-center gap-2 group">
                    Eksplorasi PetaMempawah
                    <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 7l5 5m0 0l-5 5m5-5H6" />
                    </svg>
                </a>
                <a href="https://www.arcgis.com/apps/View/index.html?appid=af46a03227ae42208b69294dcde11164"
                    class="w-full sm:w-auto px-8 py-4 glass hover:bg-white/10 rounded-2xl font-bold transition-all flex items-center justify-center gap-2">
                    Arcgis Mempawah
                </a>
            </div>
        </div>
    </section>

    <!-- Features / Links Section -->
    <section id="peta" class="py-24 px-6">
        <div class="max-w-7xl mx-auto">
            <div class="flex flex-col md:flex-row md:items-end justify-between mb-16 gap-6">
                <div>
                    <h2 class="text-3xl font-bold mb-4">Layanan Peta Eksternal</h2>
                    <p class="text-slate-400 max-w-xl">Akses berbagai sumber peta terpercaya dari instansi terkait untuk
                        referensi data geografis yang lebih luas.</p>
                </div>
                <div class="h-[1px] flex-grow bg-slate-800 mx-8 hidden md:block"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Card 1 -->
                <a href="https://tanahair.indonesia.go.id/portal-web" target="_blank"
                    class="glass-card p-8 rounded-3xl relative overflow-hidden group">
                    <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                        <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z" />
                        </svg>
                    </div>
                    <div
                        class="w-12 h-12 rounded-2xl bg-emerald-500/20 text-emerald-400 flex items-center justify-center mb-6">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 002 2h2.5M15 21a2 2 0 01-2-2m-4-3h1.341a2 2 0 001.708-1.043l.634-1.268a2 2 0 011.708-1.043H15V3" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">RBI - Indonesia</h3>
                    <p class="text-sm text-slate-400 leading-relaxed mb-6">Rupa Bumi Indonesia menyediakan data
                        geospasial dasar wilayah Negara Kesatuan Republik Indonesia.</p>
                    <span class="text-blue-400 text-sm font-semibold flex items-center gap-1">
                        Kunjungi Situs
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                    </span>
                </a>

                <!-- Card 2 -->
                <a href="https://geoportal.atrbpn.go.id/" target="_blank"
                    class="glass-card p-8 rounded-3xl relative overflow-hidden group">
                    <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                        <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 3L2 12h3v8h6v-6h2v6h6v-8h3L12 3z" />
                        </svg>
                    </div>
                    <div
                        class="w-12 h-12 rounded-2xl bg-blue-500/20 text-blue-400 flex items-center justify-center mb-6">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">GISTARU - ATR/BPN</h3>
                    <p class="text-sm text-slate-400 leading-relaxed mb-6">Sistem Informasi Tata Ruang untuk memantau
                        pemanfaatan ruang dan pertanahan secara digital.</p>
                    <span class="text-blue-400 text-sm font-semibold flex items-center gap-1">
                        Kunjungi Situs
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                    </span>
                </a>

                <!-- Card 3 -->
                <a href="https://google.com/maps" target="_blank"
                    class="glass-card p-8 rounded-3xl relative overflow-hidden group">
                    <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                        <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z" />
                        </svg>
                    </div>
                    <div
                        class="w-12 h-12 rounded-2xl bg-orange-500/20 text-orange-400 flex items-center justify-center mb-6">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Google Maps Satellite</h3>
                    <p class="text-sm text-slate-400 leading-relaxed mb-6">Tampilan satelit real-time dan navigasi
                        komprehensif untuk pemetaan lokasi secara umum.</p>
                    <span class="text-blue-400 text-sm font-semibold flex items-center gap-1">
                        Kunjungi Situs
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                    </span>
                </a>
            </div>
        </div>
    </section>

    <!-- Planning Links Section -->
    <section id="perencanaan" class="py-24 px-6 relative">
        <div class="absolute inset-0 bg-blue-600/5 -skew-y-3 pointer-events-none"></div>
        <div class="max-w-7xl mx-auto relative mt-10">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-extrabold mb-4">Website Perencanaan</h2>
                <p class="text-slate-400 max-w-2xl mx-auto">Sistem pendukung keputusan dan dokumentasi perencanaan
                    pembangunan wilayah.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div class="glass ring-1 ring-white/10 p-1 rounded-[2.5rem]">
                    <div class="bg-slate-900/50 p-10 rounded-[2.2rem]">
                        <div class="flex items-start gap-6">
                            <div
                                class="w-16 h-16 rounded-2xl bg-indigo-500/10 text-indigo-400 flex items-center justify-center shrink-0">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold mb-4">SIPD-RI</h3>
                                <p class="text-slate-400 mb-6 leading-relaxed">
                                    Sistem Informasi Pemerintahan Daerah yang menghubungkan perencanaan, penganggaran,
                                    dan evaluasi pembangunan daerah secara nasional.
                                </p>
                                <a href="https://sipd.go.id" target="_blank"
                                    class="inline-flex items-center gap-2 text-white px-6 py-3 bg-indigo-600/20 hover:bg-indigo-600/40 rounded-xl transition-all border border-indigo-500/30">
                                    Buka Platform
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="glass ring-1 ring-white/10 p-1 rounded-[2.5rem]">
                    <div class="bg-slate-900/50 p-10 rounded-[2.2rem]">
                        <div class="flex items-start gap-6">
                            <div
                                class="w-16 h-16 rounded-2xl bg-violet-500/10 text-violet-400 flex items-center justify-center shrink-0">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold mb-4">Data Statistik - BPS</h3>
                                <p class="text-slate-400 mb-6 leading-relaxed">
                                    Layanan data statistik formal untuk mendukung analisis geospasial dan demografi
                                    wilayah dalam perencanaan pembangunan.
                                </p>
                                <a href="https://www.bps.go.id" target="_blank"
                                    class="inline-flex items-center gap-2 text-white px-6 py-3 bg-violet-600/20 hover:bg-violet-600/40 rounded-xl transition-all border border-violet-500/30">
                                    Lihat Data
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Preview / CTA -->
    <section class="py-24 px-6">
        <div class="max-w-5xl mx-auto glass rounded-[3rem] overflow-hidden relative group">
            <div class="absolute inset-0 bg-gradient-to-br from-blue-600/20 to-transparent pointer-events-none"></div>
            <div class="p-12 md:p-20 text-center relative z-10">
                <h2 class="text-4xl md:text-5xl font-extrabold mb-8">Siap Untuk Eksplorasi?</h2>
                <p class="text-slate-400 mb-12 max-w-2xl mx-auto text-lg">Masuk ke dashboard interaktif kami untuk
                    melihat visualisasi data jalan, lokasi fasilitas, dan batas wilayah secara detail.</p>
                <a href="/map"
                    class="inline-flex items-center gap-3 px-10 py-5 bg-white text-slate-950 rounded-2xl font-black text-xl hover:scale-105 active:scale-95 transition-all shadow-2xl shadow-white/10">
                    BUKA DATA MAP
                    <div class="w-8 h-8 rounded-full bg-blue-600 flex items-center justify-center text-white">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </div>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="py-12 px-6 border-t border-slate-800">
        <div class="max-w-7xl mx-auto flex flex-col md:flex-row justify-between items-center gap-6">
            <div class="flex items-center gap-2 opacity-60">
                <span class="font-bold">PetaMempawah Portal</span>
                <span class="text-slate-600">|</span>
                <span class="text-xs">© 2024 GIS System Integration</span>
            </div>
            <div class="flex items-center gap-8 text-sm text-slate-500">
                <a href="#" class="hover:text-blue-400">Privacy Policy</a>
                <a href="#" class="hover:text-blue-400">Terms of Service</a>
                <a href="#" class="hover:text-blue-400">Contact Support</a>
            </div>
        </div>
    </footer>

    <!-- Smooth Scrolling -->
    <script>
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
</body>

</html><?php /**PATH D:\laragon\www\filammaps\resources\views/welcome.blade.php ENDPATH**/ ?>