<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Stunting extends Model
{
    protected $guarded = [];

    public function village(): BelongsTo
    {
        return $this->belongsTo(Village::class);
    }

    public function details(): HasMany
    {
        return $this->hasMany(StuntingDetail::class);
    }
}
