<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Road extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'coordinates' => 'array',
    ];

    public function village(): BelongsTo
    {
        return $this->belongsTo(Village::class);
    }

    public function details(): HasMany
    {
        return $this->hasMany(RoadDetail::class);
    }

    public function latestDetail()
    {
        return $this->hasOne(RoadDetail::class)->latestOfMany();
    }
}
