<?php

namespace App\Filament\Resources\Roads\RelationManagers;

use Filament\Actions\AssociateAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\DissociateAction;
use Filament\Actions\DissociateBulkAction;
use Filament\Actions\EditAction;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DetailsRelationManager extends RelationManager
{
    protected static string $relationship = 'details';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('year_data')
                    ->required()
                    ->numeric(),
                TextInput::make('length_meters')
                    ->required()
                    ->numeric(),
                TextInput::make('condition')
                    ->required(),
                FileUpload::make('photo_path')
                    ->image()
                    ->disk('public')
                    ->directory('roads')
                    ->label('Photo'),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('year_data')
            ->columns([
                TextColumn::make('year_data')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('length_meters')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('condition')
                    ->searchable(),
                ImageColumn::make('photo_path')
                    ->label('Photo'),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make(),
                AssociateAction::make(),
            ])
            ->recordActions([
                EditAction::make(),
                DissociateAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DissociateBulkAction::make(),
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
